/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.globalsetting.service.impl;

import com.tp_link.eap.d.b;
import com.tp_link.eap.domain.eapsetting.MacFilterConfig;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.globalsetting.MacAddress;
import com.tp_link.eap.domain.globalsetting.Ssid;
import com.tp_link.eap.domain.globalsetting.StationMacList;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.globalsetting.model.MacAddressInfo;
import com.tp_link.eap.monitor.globalsetting.model.MacFilterInfo;
import com.tp_link.eap.monitor.globalsetting.repo.MacAddressRepository;
import com.tp_link.eap.monitor.globalsetting.repo.MongoSequenceRepository;
import com.tp_link.eap.monitor.globalsetting.repo.StationMacListRepository;
import com.tp_link.eap.monitor.globalsetting.service.f;
import com.tp_link.eap.monitor.globalsetting.service.impl.MessageObjectBuilder;
import com.tp_link.eap.monitor.globalsetting.service.m;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.repo.site.SiteRepository;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import com.tp_link.eap.util.p.a;
import com.tp_link.eap.util.p.c;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Validator;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Component(value="StationMacListService")
public class StationMacListService
extends com.tp_link.eap.i.a.a<StationMacList>
implements m {
    @Autowired
    private StationMacListRepository b;
    @Autowired
    private MacAddressRepository c;
    @Autowired
    private MongoSequenceRepository d;
    @Autowired
    private MessageObjectBuilder e;
    @Autowired
    private com.tp_link.eap.monitor.record.service.a f;
    @Autowired
    private f g;
    @Autowired
    private MongoTemplate h;
    @Autowired
    private SiteRepository i;
    @Autowired
    private Validator validator;
    private Logger j = LoggerFactory.getLogger(this.getClass());

    public List<StationMacList> getList(QueryPage queryPage) {
        List<StationMacList> list = this.b.getByFilters(queryPage, null, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<StationMacList> getList(QueryPage queryPage, QuerySort querySort) {
        List<StationMacList> list = this.b.getByFilters(queryPage, querySort, null, null);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<StationMacList> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<StationMacList> list = this.b.getByFilters(queryPage, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public List<StationMacList> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<StationMacList> list = this.b.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<StationMacList> list = this.b.getByFilters(null, null, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return 0L;
        }
        return list.size();
    }

    @Override
    public List<StationMacList> getAll() {
        return com.tp_link.eap.util.a.a.a(this.b.findAll());
    }

    @Override
    public boolean deleteAll() {
        this.e.g();
        this.b.deleteAll();
        this.c.deleteAll();
        return true;
    }

    @Override
    public StationMacList getById(Integer id) {
        return (StationMacList)this.b.findOne(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addMacListName(String name) {
        Object object;
        StationMacList stationMacList;
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)name)) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.j.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object2 = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object2) {
            if (this.i.findBySiteName(string) == null) {
                this.j.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            if (this.b.countBySite(string) >= (long)com.tp_link.eap.util.e.bw.intValue()) {
                return new OperationResponse(ResErrorCode.aG);
            }
            stationMacList = this.b.findByNameAndSite(name, string);
            if (stationMacList != null) {
                return new OperationResponse(ResErrorCode.aH, String.format("MAC List %s is already existed.", name), null);
            }
            com.tp_link.eap.d.b.g((String)string);
            object = new StationMacList();
            object.setName(name);
            object.setSite(string);
            object.setId(this.d.getSequenceStartNumber("stationmaclist"));
            object.setAddresseList(new ArrayList());
            this.b.save(object);
        }
        object2 = this.b.findByNameAndSite(name, string);
        if (object2 == null) {
            return new OperationResponse(ResErrorCode.i);
        }
        stationMacList = this.e.b(1, object2.getId(), null, null);
        this.f.refreshRecord("macFilterList", stationMacList);
        object = new HashMap();
        object.put("id", object2.getId());
        return new OperationResponse(ResErrorCode.a, object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse editMacListName(Integer id, String name) {
        StationMacList stationMacList;
        if (id == null || name == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.j.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        StationMacList stationMacList2 = new StationMacList();
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.i.findBySiteName(string) == null) {
                this.j.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            stationMacList = (StationMacList)this.b.findOne(id);
            if (stationMacList == null) {
                return new OperationResponse(ResErrorCode.aI);
            }
            StationMacList stationMacList3 = this.b.findByNameAndSite(name, string);
            if (stationMacList3 != null && !id.equals(stationMacList3.getId())) {
                return new OperationResponse(ResErrorCode.aJ, String.format("MAC List with name %s is alrealy existed, can not rename.", name), null);
            }
            com.tp_link.eap.d.b.g((String)string);
            stationMacList2.setName(stationMacList.getName());
            stationMacList2.setId(stationMacList.getId());
            stationMacList.setName(name);
            this.b.save(stationMacList);
        }
        object = 3;
        stationMacList = this.e.b((Integer)object, id, null, stationMacList2);
        this.f.refreshRecord("macFilterList", stationMacList);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delMacList(Integer id) {
        MacFilterConfig macFilterConfig;
        if (id == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.j.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            MacAddress macAddress2;
            if (this.i.findBySiteName(string) == null) {
                this.j.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            StationMacList stationMacList = (StationMacList)this.b.findOne(id);
            if (stationMacList == null) {
                return new OperationResponse(ResErrorCode.aK);
            }
            List list = stationMacList.getAddresseList();
            macFilterConfig = this.e.b(2, id, null, stationMacList);
            if (list != null) {
                for (MacAddress macAddress2 : list) {
                    this.c.delete(macAddress2);
                }
            }
            com.tp_link.eap.d.b.g((String)com.tp_link.eap.d.b.a());
            this.b.delete(id);
            Query query = new Query();
            query.addCriteria(Criteria.where((String)"site").is((Object)string)).addCriteria(Criteria.where((String)"macFilterId").is((Object)id));
            macAddress2 = new Update();
            macAddress2.set("macFilterId", null).set("filteringAction", (Object)false);
            this.h.updateMulti(query, (Update)macAddress2, Ssid.class);
        }
        this.f.refreshRecord("macFilterList", macFilterConfig);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized OperationResponse editMacAddress(Integer listId, MacAddress macAddress) {
        if (listId == null || macAddress == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        MacFilterConfig macFilterConfig = null;
        Integer n2 = 3;
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.j.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.i.findBySiteName(string) == null) {
                this.j.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            StationMacList stationMacList = (StationMacList)this.b.findOne(listId);
            if (stationMacList == null) {
                return new OperationResponse(ResErrorCode.aI);
            }
            ArrayList<MacAddress> arrayList2 = stationMacList.getAddresseList();
            if (arrayList2 == null) {
                arrayList2 = new ArrayList<MacAddress>();
            }
            com.tp_link.eap.d.b.g((String)com.tp_link.eap.d.b.a());
            MacAddress macAddress2 = null;
            macAddress.setAddress(l.c((String)macAddress.getAddress()));
            if (macAddress.getId() == null) {
                if (this.c.countByFilterId(listId) >= (long)com.tp_link.eap.util.e.by.intValue()) {
                    return new OperationResponse(ResErrorCode.aL);
                }
                MacAddress macAddress3 = this.c.findByAddressAndFilterId(macAddress.getAddress(), listId);
                if (macAddress3 != null) {
                    return new OperationResponse(ResErrorCode.aM);
                }
                Integer n3 = this.d.getSequenceStartNumber("macAddress");
                macAddress.setId(n3);
                macAddress.setSite(com.tp_link.eap.d.b.a());
                macAddress.setFilterId(listId);
                this.c.save(macAddress);
                arrayList2.add(macAddress);
                stationMacList.setAddresseList(arrayList2);
                this.b.save(stationMacList);
                n2 = 1;
                arrayList.add(n3);
            } else {
                MacAddress macAddress4 = this.c.findByAddressAndFilterId(macAddress.getAddress(), listId);
                if (macAddress4 != null) {
                    if (macAddress4.getId().intValue() != macAddress.getId().intValue()) {
                        return new OperationResponse(ResErrorCode.aM, String.format("MAC address %s is already existed in %s", macAddress.getAddress(), stationMacList.getName()), null);
                    }
                    if (macAddress4.getDescription() == null) {
                        if (macAddress.getDescription() != null) {
                            this.c.save(macAddress);
                        }
                        return com.tp_link.eap.util.e.bd;
                    }
                    if (macAddress4.getDescription() != null) {
                        if (!macAddress4.getDescription().equals(macAddress.getDescription())) {
                            this.c.save(macAddress);
                        }
                        return com.tp_link.eap.util.e.bd;
                    }
                    return com.tp_link.eap.util.e.bd;
                }
                macAddress2 = (MacAddress)this.c.findOne(macAddress.getId());
                assert (macAddress2 != null);
                macAddress2.setNameForold(stationMacList.getName());
                this.c.save(macAddress);
                arrayList.add(macAddress.getId());
            }
            macFilterConfig = this.e.b(n2, listId, arrayList, macAddress2);
            if (macFilterConfig == null) {
                return new OperationResponse(ResErrorCode.aN);
            }
        }
        this.f.refreshRecord("macFilterList", macFilterConfig);
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse delMacAddress(Integer listId, Integer addressId) {
        MacFilterConfig macFilterConfig;
        if (listId == null || addressId == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        com.tp_link.eap.d.b.g((String)com.tp_link.eap.d.b.a());
        StationMacList stationMacList = (StationMacList)this.b.findOne(listId);
        String string = com.tp_link.eap.d.b.a();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.j.warn("Invalid site.");
            return new OperationResponse(ResErrorCode.ck);
        }
        Object object = com.tp_link.eap.b.b.a.l((String)string);
        synchronized (object) {
            if (this.i.findBySiteName(string) == null) {
                this.j.warn("Site {} doesn't exist.", (Object)string);
                com.tp_link.eap.b.b.a.m((String)string);
                return new OperationResponse(ResErrorCode.ck);
            }
            MacAddress macAddress = (MacAddress)this.c.findOne(addressId);
            if (stationMacList == null || macAddress == null) {
                return new OperationResponse(ResErrorCode.aP);
            }
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(addressId);
            macAddress.setNameForold(stationMacList.getName());
            macFilterConfig = this.e.b(2, listId, arrayList, macAddress);
            List list = stationMacList.getAddresseList();
            list.remove(macAddress);
            this.c.delete(addressId);
            stationMacList.setAddresseList(list);
            this.b.save(stationMacList);
        }
        this.f.refreshRecord("macFilterList", macFilterConfig);
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public MacAddress getMacAddressById(Integer addressId) {
        return (MacAddress)this.c.findOne(addressId);
    }

    @Override
    public OperationResponse saveStationMacList(StationMacList stationMacList) {
        Object v;
        if (stationMacList == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        OperationResponse operationResponse = this.addMacListName(stationMacList.getName());
        Object object = operationResponse.getResult();
        if (object != null && object instanceof Map && (v = ((Map)object).get("id")) != null && v instanceof Integer) {
            int n2 = (Integer)v;
            List list = stationMacList.getAddresseList();
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (MacAddress macAddress : list) {
                    macAddress.setId(null);
                    this.editMacAddress(n2, macAddress);
                }
            }
        }
        return com.tp_link.eap.util.e.bd;
    }

    @Override
    public OperationResult saveBatchSationMacList(List<StationMacList> filters) {
        if (filters == null) {
            return com.tp_link.eap.util.e.bc;
        }
        if (filters.size() > com.tp_link.eap.util.e.bw) {
            this.j.debug(String.format("Number of MAC filters is out of range %d. Others will be skipped.", com.tp_link.eap.util.e.bw));
        }
        com.tp_link.eap.d.b.g((String)com.tp_link.eap.d.b.a());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (StationMacList stationMacList : filters) {
            StationMacList stationMacList2 = new StationMacList();
            Integer n2 = this.d.getSequenceStartNumber("stationmaclist");
            stationMacList2.setName(stationMacList.getName());
            stationMacList2.setId(n2);
            if (stationMacList2.getSite() == null) {
                stationMacList2.setSite(com.tp_link.eap.d.b.a());
            }
            ArrayList<MacAddress> arrayList2 = new ArrayList<MacAddress>();
            List list = stationMacList.getAddresseList();
            if (list == null) {
                stationMacList2.setAddresseList(arrayList2);
                this.b.save(stationMacList2);
                continue;
            }
            if (list.size() > com.tp_link.eap.util.e.by) {
                this.j.debug(String.format("Number of MAC address of MAC filter %s is out of range %d. Others will be skipped.", stationMacList.getName(), com.tp_link.eap.util.e.by));
            }
            for (MacAddress macAddress : list) {
                Integer n3 = this.d.getSequenceStartNumber("macAddress");
                arrayList.add(n3);
                macAddress.setId(n3);
                macAddress.setFilterId(n2);
                macAddress.setSite(com.tp_link.eap.d.b.a());
                this.c.save(macAddress);
                arrayList2.add(macAddress);
            }
            stationMacList2.setAddresseList(arrayList2);
            this.b.save(stationMacList2);
        }
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public void deleteBySite() {
        String string = com.tp_link.eap.d.b.a();
        List<StationMacList> list = this.b.findBySiteOrderByIdAsc(string);
        if (!CollectionUtils.isEmpty(list)) {
            for (StationMacList stationMacList : list) {
                List list2 = stationMacList.getAddresseList();
                if (list2 != null) {
                    this.c.delete(stationMacList.getAddresseList());
                }
                this.b.delete(stationMacList);
            }
        }
    }

    @Override
    public List<StationMacList> getAllWithLazyLoad() {
        Query query = new Query();
        query.fields().include("id").include("name");
        query.with(new Sort(Sort.DEFAULT_DIRECTION, new String[]{"id"}));
        query.addCriteria(Criteria.where((String)"site").is((Object)com.tp_link.eap.d.b.a()));
        List list = this.h.find(query, StationMacList.class);
        return list;
    }

    @Override
    public List<StationMacList> getAllBySite(String site) {
        return this.b.findBySiteOrderByIdAsc(site);
    }

    @Override
    public OperationResponse getGridMacFilterGroups(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (queryData == null) {
            return new OperationResponse(ResErrorCode.d);
        }
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("id");
        }
        Grid grid = new Grid(queryData);
        grid.initFilters(queryData.getFilters());
        long l2 = this.count(grid.getFilters(), grid.getSearchFilters());
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        if (list == null || list.isEmpty()) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList<StationMacList> arrayList = new ArrayList<StationMacList>();
        for (StationMacList stationMacList : list) {
            stationMacList.setAddresseList(null);
            arrayList.add(stationMacList);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse addMacFilterGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("name");
        if (com.tp_link.eap.util.a.e.a((String)string) || !com.tp_link.eap.util.p.c.a((String)string, (int)1, (int)32)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.addMacListName(string);
    }

    @Override
    public OperationResponse modifyMacFilterGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("id");
        String string = jSONObject.optString("name");
        if (com.tp_link.eap.util.a.e.a((String)string) || !com.tp_link.eap.util.p.c.a((String)string, (int)1, (int)32)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.editMacListName(n2, string);
    }

    @Override
    public OperationResponse deleteMacFilterGroup(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("id");
        return this.delMacList(n2);
    }

    @Override
    public OperationResponse getGridMacFilterAddresses(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        Grid grid = new Grid(queryData);
        Integer n2 = null;
        try {
            n2 = Integer.parseInt(queryData.getFilters().get("filterId").toString());
        }
        catch (Exception exception) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        queryData.getFilters().put("filterId", n2);
        grid.initFilters(queryData.getFilters());
        grid.initSearch(queryData.getSearchKey(), new String[]{"address"});
        Long l2 = this.g.count(grid);
        StationMacList stationMacList = this.getById(n2);
        if (stationMacList == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        grid.setTotalRows(l2.longValue());
        List list = this.g.getList(grid);
        if (list == null) {
            return new OperationResponse(ResErrorCode.a, (Object)grid);
        }
        ArrayList<MacAddressInfo> arrayList = new ArrayList<MacAddressInfo>();
        int n3 = queryData.getCurrentPage();
        int n4 = queryData.getCurrentPageSize();
        int n5 = (n3 - 1) * n4;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            MacAddress macAddress = (MacAddress)list.get(i2);
            MacAddressInfo macAddressInfo = new MacAddressInfo();
            macAddressInfo.setIndex(i2 + 1 + n5);
            macAddressInfo.setAddress(macAddress.getAddress());
            macAddressInfo.setDescription(macAddress.getDescription());
            macAddressInfo.setFilterId(n2);
            macAddressInfo.setFilterName(stationMacList.getName());
            macAddressInfo.setAddressId(macAddress.getId());
            arrayList.add(macAddressInfo);
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse addMacFilterAddress(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        MacAddressInfo macAddressInfo = (MacAddressInfo)JSONObject.toBean((JSONObject)jSONObject, MacAddressInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)macAddressInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        Integer n2 = macAddressInfo.getFilterId();
        MacAddress macAddress = new MacAddress();
        macAddress.setAddress(macAddressInfo.getAddress());
        macAddress.setDescription(macAddressInfo.getDescription());
        return this.editMacAddress(n2, macAddress);
    }

    @Override
    public OperationResponse modifyMacFilterAddress(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        MacAddressInfo macAddressInfo = (MacAddressInfo)JSONObject.toBean((JSONObject)jSONObject, MacAddressInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)macAddressInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        Integer n2 = macAddressInfo.getFilterId();
        MacAddress macAddress = this.getMacAddressById(macAddressInfo.getAddressId());
        if (macAddress == null) {
            return new OperationResponse(ResErrorCode.aO);
        }
        macAddress.setAddress(macAddressInfo.getAddress());
        macAddress.setDescription(macAddressInfo.getDescription());
        return this.editMacAddress(n2, macAddress);
    }

    @Override
    public OperationResponse deleteMacFilterAddress(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        MacAddressInfo macAddressInfo = (MacAddressInfo)JSONObject.toBean((JSONObject)jSONObject, MacAddressInfo.class);
        OperationResponse operationResponse = com.tp_link.eap.util.p.a.a((Validator)this.validator, (Object)macAddressInfo);
        if (!operationResponse.success()) {
            return operationResponse;
        }
        StationMacList stationMacList = this.getById(macAddressInfo.getFilterId());
        if (stationMacList == null) {
            return new OperationResponse(ResErrorCode.aP);
        }
        return this.delMacAddress(macAddressInfo.getFilterId(), macAddressInfo.getAddressId());
    }

    @Override
    public OperationResponse getMacFilterGroupList(ControlType controlType, JSONObject reqObj) {
        ArrayList<MacFilterInfo> arrayList = new ArrayList<MacFilterInfo>();
        List<StationMacList> list = this.getAllWithLazyLoad();
        HashMap<String, ArrayList<MacFilterInfo>> hashMap = new HashMap<String, ArrayList<MacFilterInfo>>();
        if (list != null) {
            for (StationMacList stationMacList : list) {
                MacFilterInfo macFilterInfo = new MacFilterInfo();
                macFilterInfo.setId(stationMacList.getId());
                macFilterInfo.setName(stationMacList.getName());
                arrayList.add(macFilterInfo);
            }
        }
        hashMap.put("data", arrayList);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse uploadFilterAddressFile(HttpServletRequest request, HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        Object object;
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("filterId");
        MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
        InputStream inputStream = null;
        List list = new ArrayList();
        MultipartFile multipartFile = multipartHttpServletRequest.getFile("file");
        if (multipartFile.isEmpty()) {
            return new OperationResponse(ResErrorCode.bd);
        }
        try {
            inputStream = multipartFile.getInputStream();
            object = multipartFile.getOriginalFilename();
            list = ((String)object).substring(((String)object).lastIndexOf(".")).equals(".csv") ? com.tp_link.eap.util.b.a.a((InputStream)inputStream) : new com.tp_link.eap.util.f.a().a(inputStream, multipartFile.getOriginalFilename(), 2);
            inputStream.close();
        }
        catch (Exception exception) {
            this.j.warn(exception.toString(), (Throwable)exception);
            this.j.error("Proc upload file failed!");
            return new OperationResponse(ResErrorCode.be);
        }
        object = this.a(list, n2);
        if (object.size() < list.size()) {
            return new OperationResponse(ResErrorCode.bf);
        }
        if (!CollectionUtils.isEmpty((Collection)object)) {
            MacAddress macAddress;
            int n3 = 0;
            Object object2 = object.iterator();
            while (object2.hasNext()) {
                macAddress = (MacAddress)object2.next();
                if (macAddress.getId() == null) continue;
                ++n3;
            }
            if ((long)(object.size() - n3) + this.c.countByFilterId(n2) > 50000L) {
                object2 = new HashMap();
                object2.put("data", "over");
                return new OperationResponse(ResErrorCode.bg, object2);
            }
            object2 = object.iterator();
            while (object2.hasNext()) {
                macAddress = (MacAddress)object2.next();
                this.editMacAddress(n2, macAddress);
            }
            return new OperationResponse(ResErrorCode.a, "Success", null);
        }
        this.j.error("Empty Mac address file.");
        return new OperationResponse(ResErrorCode.bh);
    }

    @Override
    public OperationResponse uploadFilterAddressFile(ControlType controlType, JSONObject reqData, String fileName, byte[] fileContent) {
        JSONObject jSONObject = reqData.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        if (fileContent.length <= 0) {
            return new OperationResponse(ResErrorCode.bd);
        }
        Integer n2 = jSONObject.getInt("filterId");
        List list = new ArrayList();
        try {
            list = fileName.substring(fileName.lastIndexOf(".")).equals(".csv") ? com.tp_link.eap.util.b.a.a((InputStream)new ByteArrayInputStream(fileContent)) : new com.tp_link.eap.util.f.a().a((InputStream)new ByteArrayInputStream(fileContent), fileName, 2);
        }
        catch (Exception exception) {
            this.j.warn(exception.toString(), (Throwable)exception);
            this.j.error("Proc upload file failed!");
            return new OperationResponse(ResErrorCode.be);
        }
        List<MacAddress> list2 = this.a(list, n2);
        if (list2.size() < list.size()) {
            return new OperationResponse(ResErrorCode.bf);
        }
        if (!CollectionUtils.isEmpty(list2)) {
            int n3 = 0;
            for (MacAddress macAddress : list2) {
                if (macAddress.getId() == null) continue;
                ++n3;
            }
            if ((long)(list2.size() - n3) + this.c.countByFilterId(n2) > 50000L) {
                HashMap hashMap = new HashMap();
                hashMap.put("data", "over");
                return new OperationResponse(ResErrorCode.bg, (Object)hashMap);
            }
            for (MacAddress macAddress : list2) {
                this.editMacAddress(n2, macAddress);
            }
            return new OperationResponse(ResErrorCode.a, "Success", null);
        }
        this.j.error("Empty Mac address file.");
        return new OperationResponse(ResErrorCode.bh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFilterAddressFile(HttpServletResponse response, ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            response.setStatus(404);
            return;
        }
        Integer n2 = jSONObject.getInt("filterId");
        Integer n3 = (int)n2;
        StationMacList stationMacList = null;
        stationMacList = this.getById(n3);
        if (null != stationMacList) {
            String string = "MacFilter_" + com.tp_link.eap.d.b.a() + "_";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
            string = string.concat(simpleDateFormat.format(new Date()).toString());
            List list = stationMacList.getAddresseList();
            List<Map<String, Object>> list2 = this.a(list);
            String[] stringArray = new String[]{"Mac Address", "Description"};
            String[] stringArray2 = new String[]{"mac_address", "description"};
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                com.tp_link.eap.util.f.a.a(list2, (String[])stringArray2, (String[])stringArray).write((OutputStream)byteArrayOutputStream);
            }
            catch (IOException iOException) {
                this.j.warn(iOException.toString(), (Throwable)iOException);
            }
            BufferedInputStream bufferedInputStream = null;
            FilterOutputStream filterOutputStream = null;
            try {
                int n4;
                byte[] byArray = byteArrayOutputStream.toByteArray();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                response.reset();
                response.setContentType("application/vnd.ms-excel;charset=utf-8");
                response.setHeader("Content-Disposition", "attachment;filename=" + new String((string + ".xls").getBytes(), "iso-8859-1"));
                ServletOutputStream servletOutputStream = response.getOutputStream();
                bufferedInputStream = new BufferedInputStream(byteArrayInputStream);
                filterOutputStream = new BufferedOutputStream((OutputStream)servletOutputStream);
                byte[] byArray2 = new byte[2048];
                while (-1 != (n4 = bufferedInputStream.read(byArray2, 0, byArray2.length))) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray2, 0, n4);
                }
            }
            catch (IOException iOException) {
                response.setStatus(404);
            }
            finally {
                try {
                    if (bufferedInputStream != null) {
                        bufferedInputStream.close();
                    }
                    if (filterOutputStream != null) {
                        filterOutputStream.close();
                    }
                }
                catch (IOException iOException) {
                    response.setStatus(404);
                }
            }
        }
    }

    @Override
    public OperationResponse downloadFilterAddressFile(String transferId, ControlType controlType, JSONObject reqObj, ChannelHandlerContext ctx) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        Integer n2 = jSONObject.getInt("filterId");
        Integer n3 = (int)n2;
        StationMacList stationMacList = null;
        stationMacList = this.getById(n3);
        if (null != stationMacList) {
            String string = "MacFilter_" + com.tp_link.eap.d.b.a() + "_";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
            string = string.concat(simpleDateFormat.format(new Date()).toString());
            List list = stationMacList.getAddresseList();
            List<Map<String, Object>> list2 = this.a(list);
            String[] stringArray = new String[]{"Mac Address", "Description"};
            String[] stringArray2 = new String[]{"mac_address", "description"};
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                com.tp_link.eap.util.f.a.a(list2, (String[])stringArray2, (String[])stringArray).write((OutputStream)byteArrayOutputStream);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = Base64.getEncoder().encode(byArray);
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])byArray2);
                DefaultFullHttpResponse defaultFullHttpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, byteBuf);
                defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.KEEP_ALIVE);
                defaultFullHttpResponse.headers().set((CharSequence)"X-Transfer-Id", (Object)transferId);
                defaultFullHttpResponse.headers().set((CharSequence)"Encode", (Object)"base64");
                defaultFullHttpResponse.headers().set((CharSequence)"Content-Disposition", (Object)("attachment;filename=" + new String((string + ".xls").getBytes(), "iso-8859-1")));
                defaultFullHttpResponse.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)byArray2.length);
                com.tp_link.eap.monitor.cloud.proxy.a.a.a(ctx, defaultFullHttpResponse);
                return com.tp_link.eap.util.e.bd;
            }
            catch (IOException iOException) {
                this.j.warn(iOException.toString(), (Throwable)iOException);
                return com.tp_link.eap.util.e.aY;
            }
        }
        return com.tp_link.eap.util.e.aY;
    }

    @Override
    public OperationResponse checkMacFilterOverLimit(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.j.warn("Invalid request, params is null.");
            return com.tp_link.eap.util.e.aZ;
        }
        int n2 = jSONObject.getInt("filterId");
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("data", this.c.countByFilterId(n2) >= (long)com.tp_link.eap.util.e.by.intValue());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    private List<MacAddress> a(List<String[]> list, Integer n2) {
        if (list == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("([A-Fa-f0-9]{2}[-:]){5}[A-Fa-f0-9]{2}");
        String string = com.tp_link.eap.d.b.a();
        ArrayList<MacAddress> arrayList = new ArrayList<MacAddress>();
        try {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String[] stringArray = list.get(i2);
                MacAddress macAddress = new MacAddress();
                if (stringArray[0].trim().equals("")) continue;
                if (!pattern.matcher(stringArray[0].trim()).matches()) {
                    this.j.error("Not a macaddress = " + stringArray[0].trim());
                    continue;
                }
                macAddress.setAddress(l.c((String)String.valueOf(stringArray[0].trim())));
                macAddress.setDescription(stringArray[1].trim());
                macAddress.setSite(string);
                MacAddress macAddress2 = this.c.findByAddressAndFilterId(macAddress.getAddress(), n2);
                if (macAddress2 != null) {
                    macAddress.setFilterId(macAddress2.getFilterId());
                    macAddress.setId(macAddress2.getId());
                }
                arrayList.add(macAddress);
            }
        }
        catch (Exception exception) {
            this.j.error("proc mac address failed!");
            exception.printStackTrace();
            return null;
        }
        return arrayList;
    }

    private List<Map<String, Object>> a(List<MacAddress> list) {
        if (list == null) {
            return null;
        }
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        MacAddress macAddress = null;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            macAddress = list.get(i2);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("mac_address", macAddress.getAddress());
            hashMap.put("description", macAddress.getDescription());
            arrayList.add(hashMap);
        }
        return arrayList;
    }
}

